#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

#define FOND_Z (1000.f)

static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5 = {0.f,360.f,FOND_Z,  128,0,0,   0,128.f,1.f/FOND_Z,{0,192/FOND_Z, 1.f/FOND_Z}};
static GrVertex Fond6 = {640.f,360,FOND_Z,   128,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,192/FOND_Z,1.f/300.f}};
static GrVertex Fond7 = {640.,480.f,FOND_Z,   128,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond8 = {0,480.f,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static Obj3d* pCube;
static Obj3d *pFace1, *pFace2, *pFace3, *pFace4, *pFace5;
static float Matrix[16];
static float Matrix2[16];

void LInit_Tourni()
{
	pCube = GenerateFloor(2,2, 200, 200, 256, 256);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, 0,0,210);
	ApplyMatrix(pCube, Matrix);
	
	pFace1 = CopyObj(pCube);
	pFace2 = CopyObj(pCube);
	pFace3 = CopyObj(pCube);
	pFace4 = CopyObj(pCube);
	pFace5 = CopyObj(pCube);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4); // PI/2
	ApplyMatrix(pFace1, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/2); // PI
	ApplyMatrix(pFace2, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192*3/4); // PI*3/2
	ApplyMatrix(pFace3, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, 8192/4); // PI/2
	ApplyMatrix(pFace4, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, -8192/4); // -PI/2
	ApplyMatrix(pFace5, Matrix2);

	pCube = CombineObj(pCube, pFace1);
	pCube = CombineObj(pCube, pFace2);
	pCube = CombineObj(pCube, pFace3);
	pCube = CombineObj(pCube, pFace4);
	pCube = CombineObj(pCube, pFace5);

	DeleteObj(pFace1);
	DeleteObj(pFace2);
	DeleteObj(pFace3);
	DeleteObj(pFace4);
	DeleteObj(pFace5);

	PrepareTextureFromArray(g_PicTourni, 256, 256, &g_TextureTourni);
	PrepareTextureFromArray(g_PicHypno, 256, 256, &g_TextureHypno);
}

void QInit_Tourni()
{
	grConstantColorValue((128<<24)+(128<<16)+(128<<8)+(128));

	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureHypno);
	DownloadTexture(&g_TextureTourni);
}

void Effect_Tourni()
{
	int Img1=0;
	static int MoveX, MoveY;
	static DWORD LastMove = 0;
	float fSize;
	DWORD dwTmp, dwTmpCube, dwTmpText;
	DWORD dwFunction;

	if (g_demostate.TickInEffect>10500-5250/16)
	{
		dwFunction = GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL;
		dwTmp = (g_demostate.TickInEffect-(10500-5250/16))*256/(5000/16);
		dwTmp = CLIP_DW(dwTmp);
		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
		dwTmpText = (11000-g_demostate.TickInEffect)*256/(5500/16);
		dwTmpCube = dwTmpText/2;
		dwTmpCube = CLIP_DW(dwTmpCube);
		dwTmpText = CLIP_DW(dwTmpText);
		dwTmpCube = (dwTmpCube<<24)+(dwTmpCube<<16)+(dwTmpCube<<8)+(dwTmpCube);
		dwTmpText = (dwTmpText<<24)+(dwTmpText<<16)+(dwTmpText<<8)+(dwTmpText);
	}
	else
	{
		dwTmpCube = (128<<24)+(128<<16)+(128<<8)+(128);
		dwTmpText = 0xffffff;
		dwFunction = GR_COMBINE_FUNCTION_SCALE_OTHER;
	}

	Img1 = -(int)g_demostate.TickInEffect/10;

	Fond1.tmuvtx[0].sow = (float)(128 + 128*sin(Img1/40.f))/FOND_Z;
	Fond1.tmuvtx[0].tow = (float)(128 + 127*cos(Img1/40.f))/FOND_Z;
	Fond2.tmuvtx[0].sow = (float)(128 + 128*sin(Img1/40.f+PI/2))/FOND_Z;
	Fond2.tmuvtx[0].tow = (float)(128 + 127*cos(Img1/40.f+PI/2))/FOND_Z;
	Fond3.tmuvtx[0].sow = (float)(128 + 128*sin(Img1/40.f+PI))/FOND_Z;
	Fond3.tmuvtx[0].tow = (float)(128 + 127*cos(Img1/40.f+PI))/FOND_Z;
	Fond4.tmuvtx[0].sow = (float)(128 + 128*sin(Img1/40.f+PI/2*3))/FOND_Z;
	Fond4.tmuvtx[0].tow = (float)(128 + 127*cos(Img1/40.f+PI/2*3))/FOND_Z;

	grColorCombine(dwFunction,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, 
					FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	SelectTexture(g_TextureTourni);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, 
					FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ZERO, GR_BLEND_ZERO);
	//grConstantColorValue((128<<24)+(128<<16)+(128<<8)+(128));
	grConstantColorValue(dwTmpCube);

	BeIdentityMatrix(Matrix);
	//fSize = (g_demostate.TickInEffect%(5000/16)) /(5000/16.f)/2.f + 0.75f;
	fSize = CosTable[(g_demostate.TickInEffect*8192*16/5000)&8191]*0.4f+1.f;
	if (g_demostate.TickInEffect<1000)
	{
		fSize *= (g_demostate.TickInEffect/1000.f);
	}
	ScaleMatrix(Matrix, fSize, fSize, fSize);
	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect); // 1/160
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect);
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect);
	TranslateMatrix(Matrix2, 0, 0, 700);
	DrawWithMatrix(pCube, Matrix2, false, NULL, 0);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, 
					FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE_MINUS_SRC_COLOR, GR_BLEND_ONE_MINUS_DST_COLOR, GR_BLEND_ZERO, GR_BLEND_ZERO);
	SelectTexture(g_TextureHypno);
	grConstantColorValue(dwTmpText);

	if (LastMove+45<g_demostate.TickInEffect)
	{
		LastMove = g_demostate.TickInEffect;
		MoveX = 10*SinTable[(g_demostate.TickInEffect*33)&8191];
		MoveY = 10*CosTable[(g_demostate.TickInEffect*17)&8191];
	}

	Fond5.x = 16+MoveX; Fond5.y = MoveY+350;
	Fond6.x = MoveX+624; Fond6.y = MoveY+350;
	Fond7.x = MoveX+624; Fond7.y = MoveY+470;
	Fond8.x = 16+MoveX; Fond8.y = MoveY+470;

	grDrawTriangle(&Fond5, &Fond6, &Fond7);
	grDrawTriangle(&Fond7, &Fond8, &Fond5);
}

void ByeBye_Tourni()
{
	FreeTexture(&g_TextureTourni);
	FreeTexture(&g_TextureHypno);
}